/*
 * Decompiled with CFR 0.152.
 */
package filenet.vw.apps.linker;

import filenet.vw.apps.linker.resources.VWResource;
import filenet.vw.base.VWDebug;
import filenet.vw.idm.toolkit.IVWIDMDialog;
import filenet.vw.idm.toolkit.IVWIDMDocument;
import filenet.vw.idm.toolkit.IVWIDMLibrary;
import filenet.vw.idm.toolkit.VWIDMBaseFactory;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Font;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextField;

class VWLinkerCriteriaPanel
extends JPanel
implements ActionListener {
    private JRadioButton m_documentLinkRadio = null;
    private JTextField m_documentTextField = null;
    private JButton m_browseButton = null;
    private JRadioButton m_documentClassLinkRadio = null;
    private JComboBox m_libraryCombo = null;
    private Frame m_parentFrame = null;
    private String m_linkType = "1";
    private IVWIDMDocument m_document = null;

    public VWLinkerCriteriaPanel(Frame parentFrame) {
        this.m_parentFrame = parentFrame;
        this.layoutControls();
    }

    public String getDocumentId() {
        if (this.m_document == null) {
            return null;
        }
        return this.m_document.getId();
    }

    public String getLibraryName() {
        if (this.m_libraryCombo == null) {
            return null;
        }
        return (String)this.m_libraryCombo.getSelectedItem();
    }

    public String getLinkType() {
        return this.m_linkType;
    }

    public void actionPerformed(ActionEvent event) {
        block9: {
            try {
                Object object = event.getSource();
                if (object == this.m_documentLinkRadio) {
                    this.m_browseButton.setEnabled(true);
                    this.m_libraryCombo.setEnabled(false);
                    this.m_linkType = this.m_document != null && this.m_document.isWorkflowDefinition() ? "3" : "2";
                    break block9;
                }
                if (object == this.m_browseButton) {
                    try {
                        IVWIDMDialog dialog = VWIDMBaseFactory.instance().getBrowseDialog(this.m_document, 16, VWResource.Open, null);
                        dialog.setTitle(VWResource.SelectADocument);
                        int returnVal = dialog.showDialog(this.m_parentFrame);
                        if (0 != returnVal) break block9;
                        this.m_document = (IVWIDMDocument)dialog.getSelectedItem();
                        if (this.m_document != null) {
                            this.m_documentTextField.setText(this.m_document.getLabel());
                        }
                        if (this.m_document != null && this.m_document.isWorkflowDefinition()) {
                            this.m_linkType = "3";
                            break block9;
                        }
                        this.m_linkType = "2";
                    }
                    catch (Exception ex) {
                        VWDebug.logException(ex);
                    }
                    break block9;
                }
                if (object == this.m_documentClassLinkRadio) {
                    this.m_browseButton.setEnabled(false);
                    this.m_libraryCombo.setEnabled(true);
                    this.m_linkType = "1";
                }
            }
            catch (Exception ex) {
                VWDebug.logException(ex);
            }
        }
    }

    private void layoutControls() {
        try {
            this.setLayout(new BorderLayout());
            this.setBorder(BorderFactory.createEmptyBorder(6, 6, 6, 6));
            this.add((Component)this.getTitleLabel(), "First");
            this.add((Component)this.createMiddlePanel(), "Center");
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
    }

    private JLabel getTitleLabel() {
        JLabel titleLabel = null;
        Font aFont = null;
        try {
            titleLabel = new JLabel(VWResource.SelectLinkType, 0);
            aFont = this.getFont();
            if (aFont != null) {
                titleLabel.setFont(new Font(aFont.getName(), 1, aFont.getSize() + 2));
            }
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
        return titleLabel;
    }

    private JPanel createMiddlePanel() {
        JPanel subPanel = null;
        GridBagConstraints gbCons = null;
        ButtonGroup buttonGroup = null;
        try {
            subPanel = new JPanel();
            subPanel.setLayout(new GridBagLayout());
            buttonGroup = new ButtonGroup();
            gbCons = new GridBagConstraints();
            gbCons.gridx = 0;
            gbCons.gridy = 0;
            gbCons.anchor = 23;
            gbCons.gridwidth = 1;
            gbCons.gridheight = 1;
            gbCons.insets = new Insets(12, 12, 6, 6);
            gbCons.fill = 0;
            gbCons.weightx = 0.0;
            gbCons.weighty = 0.0;
            gbCons.gridwidth = 2;
            this.m_documentLinkRadio = new JRadioButton(VWResource.DocumentLink);
            buttonGroup.add(this.m_documentLinkRadio);
            subPanel.add((Component)this.m_documentLinkRadio, gbCons);
            gbCons.gridx = 0;
            ++gbCons.gridy;
            gbCons.gridwidth = 1;
            gbCons.insets = new Insets(6, 12, 6, 6);
            subPanel.add((Component)new JPanel(), gbCons);
            ++gbCons.gridx;
            gbCons.gridwidth = 1;
            subPanel.add((Component)new JLabel(VWResource.s_label.toString(VWResource.Document), 4), gbCons);
            ++gbCons.gridx;
            gbCons.gridwidth = -1;
            gbCons.fill = 2;
            gbCons.weightx = 1.0;
            this.m_documentTextField = new JTextField();
            this.m_documentTextField.setEditable(false);
            subPanel.add((Component)this.m_documentTextField, gbCons);
            ++gbCons.gridx;
            gbCons.gridwidth = 0;
            gbCons.fill = 0;
            gbCons.weightx = 0.0;
            this.m_browseButton = new JButton(VWResource.Browse);
            this.m_browseButton.setEnabled(false);
            subPanel.add((Component)this.m_browseButton, gbCons);
            gbCons.gridx = 0;
            gbCons.gridy += 2;
            gbCons.gridwidth = 3;
            gbCons.insets = new Insets(12, 12, 6, 6);
            this.m_documentClassLinkRadio = new JRadioButton(VWResource.DocumentClassLink);
            buttonGroup.add(this.m_documentClassLinkRadio);
            this.m_documentClassLinkRadio.setSelected(true);
            subPanel.add((Component)this.m_documentClassLinkRadio, gbCons);
            gbCons.gridx = 0;
            ++gbCons.gridy;
            gbCons.gridwidth = 2;
            gbCons.insets = new Insets(6, 12, 6, 6);
            subPanel.add((Component)new JLabel(), gbCons);
            ++gbCons.gridx;
            gbCons.gridwidth = 1;
            subPanel.add((Component)new JLabel(VWResource.s_label.toString(VWResource.Library), 4), gbCons);
            ++gbCons.gridx;
            gbCons.gridwidth = -1;
            gbCons.fill = 2;
            gbCons.weightx = 1.0;
            this.m_libraryCombo = new JComboBox(this.getLibraryNames());
            subPanel.add((Component)this.m_libraryCombo, gbCons);
            ++gbCons.gridx;
            gbCons.gridwidth = 0;
            gbCons.fill = 0;
            gbCons.weightx = 0.0;
            subPanel.add((Component)new JLabel(), gbCons);
            this.m_documentLinkRadio.addActionListener(this);
            this.m_browseButton.addActionListener(this);
            this.m_documentClassLinkRadio.addActionListener(this);
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
        return subPanel;
    }

    private Vector getLibraryNames() {
        IVWIDMLibrary[] libraries = null;
        Vector<String> libraryNames = null;
        try {
            libraryNames = new Vector<String>();
            libraries = VWIDMBaseFactory.instance().getLibraries();
            if (libraries != null) {
                for (int i = 0; i < libraries.length; ++i) {
                    if (!libraries[i].hasWorkflowLinkSupport()) continue;
                    libraryNames.add(libraries[i].getLibraryLabel());
                }
            }
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
        return libraryNames;
    }
}

